<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
    <%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="ISO-8859-1">
<title>Plan View</title>

<style type="text/css">
.center{
	margin: auto;
	width: 80%;
	padding: 10px;
}
.navbar{
	/*font-family: "Google Sans",Arial,sans-serif;*/
	font-family: "Roboto",sans-serif;
}
table {
    border-collapse: collapse;
   /* margin: 25px 0;*/
    font-size: 0.9em;
    font-family: sans-serif;
    min-width: 400px;
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
}
table thead tr {
    
    text-align: left;
}
table th {
    padding: 12px 15px;
}
table td {
    padding: 10px 15px;
}

table tbody tr {
    border-bottom: 1px solid #dddddd;
}
table tbody tr:nth-of-type(even) {
    background-color: #f3f3f3;
}
table tbody tr.active-row {
    font-weight: bold;
    color: #009879;
}

.head{
	background-color:#009879;
	 color: #ffffff;
}
table tbody tr:last-of-type {
    border-bottom: 2px solid #009879;
}

.headmenu {
    width:100%;
    height:100px;
    overflow-x: scroll;
    overflow-y: hidden;
}
.navbar{
	margin-top:-10px;
	background-color:#ddd;
	overflow:hidden;
}
.navbar a{
	float:left;
	color:black;
	text-align:center;
	padding:14px 16px;
	text-decoration:none;
	font-size:16px;
}
.navbar a:hover{
	background-color:green;
	color:#fff;
}
.navbar a.select{
	background-color: #04AA6D;
	color:white;
}

</style>
</head>
<body>
		<div class="navbar">
		<a  href="/ibase/servlet/emp">Work Manager</a>
		<a class="select" href="/WorkManager/view">View Plan</a>
	</div>
	<div class="center">
	<h1 style="text-align:center">Yesterday's Feedback</h1>	
	<table width=100%>
  				<thead>
  					<tr class="head">
  						<td>Person</td>
  						<td>RequestId</td>
  						<td>Action DTL</td>
  						<td>Details</td>
  						<td>Yesterday's Effort</td>
  						<td>Total Effort</td>
  						<td>Status</td>  						
  					</tr>
  				</thead>
  				<tbody>					
					<c:forEach var="report" items="${feedbackList}">
						<tr>
							<td><c:out value="${report.person}" /></td>
							<td><c:out value="${report.requestId}" /></td>
							<td><c:out value="${report.actiondtl}" /></td>
							<td><c:out value="${report.description}" /></td>
							<td><c:out value="${report.timespend}" /></td>
							<td><c:out value="${report.stdtime}" /></td>
							<td><c:out value="${report.status}" /></td>
							<td></td>
						</tr>
					</c:forEach>
					</tbody>
  			</table>
  			<h1 style="text-align:center">Todays Plan</h1>
  			<table width=100%>
  				<thead>
  					<tr class="head">
  						<td>Person</td>
  						<td>RequestId</td>
  						<td>Request DTL</td>
  						<td>Action Details</td>
  						<td>Planned Effort</td>
  						<td>Planned Start</td>
  						<td>Plan End</td>
  						<td>Total Effort Spent</td>
  					</tr>
  				</thead>
  				<tbody>					
					<c:forEach var="plan" items="${todaysplan}">
						<tr>
							<td><c:out value="${plan.name}" /></td>
							<td><c:out value="${plan.requestid}" /></td>
							<td><c:out value="${plan.description}" /></td>
							<td><c:out value="${plan.actiondtl}" /></td>
							<td><c:out value="${plan.time}" /></td>
							<td><c:out value="${plan.date}" /></td>
							<td><c:out value="${plan.endDate}" /></td>
							<td><c:out value="${plan.spentTime}" /></td>
							<td></td>
						</tr>
					</c:forEach>
					</tbody>
  			</table>
  			</div>	
</body>
</html>